/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser;

import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogAnalyser;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.codex.CodexMessage;
import dev.kostromdan.mods.crash_assistant.app.utils.uploading_apis.Problem;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class KnownCrashReasonMessage {
    private static final Comparator<KnownCrashReasonMessage> CRASH_REASON_COMPARATOR = Comparator.comparingInt(msg -> msg.getReason().getPriority()).reversed().thenComparing(msg -> msg.getReason().getClass().getSimpleName().toLowerCase()).thenComparing(System::identityHashCode);
    private static final SortedSet<KnownCrashReasonMessage> crashReasonMessages = Collections.synchronizedSortedSet(new TreeSet<KnownCrashReasonMessage>(CRASH_REASON_COMPARATOR));
    private boolean shownWarn = false;
    private final Log log;
    private final KnownCrashReason reason;
    private boolean isCodexMessage = false;

    public Log getLog() {
        return this.log;
    }

    public KnownCrashReasonMessage(Log log, KnownCrashReason reason) {
        this.log = log;
        this.reason = reason;
    }

    public boolean isShownWarn() {
        return this.shownWarn;
    }

    public void setShownWarn(boolean value) {
        this.shownWarn = value;
    }

    public String getMessage() {
        return this.reason.getMessage().replaceAll("\\$LOG_FILENAME\\$", this.log.getFileName());
    }

    public KnownCrashReason getReason() {
        return this.reason;
    }

    public static Set<KnownCrashReasonMessage> getAllMessages() {
        return crashReasonMessages;
    }

    public static HashMap<KnownCrashReason, List<Log>> getUniqueMessages() {
        HashMap<String, List> messagesByReasonType = new HashMap<String, List>();
        HashMap<KnownCrashReason, List<Log>> result = new HashMap<KnownCrashReason, List<Log>>();
        for (KnownCrashReasonMessage message : crashReasonMessages) {
            String reasonType = message.getReason().getClass().getSimpleName().toLowerCase();
            messagesByReasonType.computeIfAbsent(reasonType, k -> new ArrayList()).add(message);
        }
        for (List messages : messagesByReasonType.values()) {
            if (messages.isEmpty()) continue;
            KnownCrashReasonMessage firstMessage = (KnownCrashReasonMessage)messages.get(0);
            KnownCrashReason reason = firstMessage.getReason();
            List logs = messages.stream().map(KnownCrashReasonMessage::getLog).collect(Collectors.toList());
            result.put(reason, logs);
        }
        return result;
    }

    public static void addCrashReasonMessage(KnownCrashReasonMessage msg) {
        crashReasonMessages.add(msg);
    }

    public static void addCodexMessage(Log log, Problem problem, String url) {
        int line = problem.getLine();
        String solutions = String.join((CharSequence)"\n", problem.getSolutions());
        String crashAssistantAnalysisOfCodex = LogAnalyser.analyseCodexMessage(problem.getMessage() + "\n" + solutions);
        Object msg = LanguageProvider.get((String)"warnings.codex").replaceAll("\\$PROBLEM\\$", problem.getMessage()).replaceAll("\\$LINE\\$", "<a href='" + url + "#L" + line + "'>" + LanguageProvider.get((String)"warnings_common.line") + " " + line + "</a>").replaceAll("\\$SOLUTIONS\\$", solutions);
        if (!crashAssistantAnalysisOfCodex.isEmpty()) {
            msg = (String)msg + "\n\n" + LanguageProvider.get((String)"warnings.codex_crash_assistant_comment") + "\n" + crashAssistantAnalysisOfCodex;
        }
        KnownCrashReasonMessage codexMsg = new KnownCrashReasonMessage(log, new CodexMessage((String)msg));
        KnownCrashReasonMessage.addCrashReasonMessage(codexMsg);
        codexMsg.isCodexMessage = true;
    }

    public boolean isCodexMessage() {
        return this.isCodexMessage;
    }
}

